<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function department()
    {
        return $this->hasOne('Department', 'department_id');
    }

    public function role()
    {
        return $this->hasOne('Role', 'role_id');
    }

    public function employee()
    {
        return $this->hasOne('Employee', 'user_id');
    }

}